﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.IO;

namespace NSM9393A
{
    public partial class Vsag_M9393A
    {
        // Delay routine to avoid using Thread.Sleep()
        public void Delay(int mSec)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            while (sw.ElapsedMilliseconds < mSec)
            {
            }
        }
    
        // Routine to convert Volts Squared to dBm
        public double voltsSquare2dBm(double voltsSquared, double impedance)
        {
            return 10 * System.Math.Log10(voltsSquared / (.001 * impedance));
        }

        public double getRrcFilterWeightSquared(double freq, double symbolRate, double alpha)
        {
            double m_symbolRate;
            double m_alpha;
            double m_lowerBreakPoint_Hz;
            double m_upperBreakPoint_Hz;
            double m_constant1;         // for calculation efficiency only
            double m_constant2;         // for calculation efficiency only

            m_symbolRate = symbolRate;
            m_alpha = alpha;
            m_lowerBreakPoint_Hz = ((1 - alpha) * symbolRate / 2);
            m_upperBreakPoint_Hz = ((1 + alpha) * symbolRate / 2);

            double f = Math.Abs(freq);

            double result;

            if (f <= m_lowerBreakPoint_Hz)
                result = 1;
            else if (f <= m_upperBreakPoint_Hz)
            {
                m_constant1 = (Math.PI / (2 * symbolRate * alpha));
                m_constant2 = (symbolRate * (1 - alpha) / 2);
                result = Math.Cos(m_constant1 * (f - m_constant2));
            }
            else
                result = 0;

            return result * result;
        }

        public double getGausFilterWeight(double freq, double bandwidth)
        {
            double B = 0.5 * bandwidth / (Math.Sqrt(Math.Log(2) / (2 * Math.PI)));
            double f = Math.Abs(freq);
            double result = Math.Exp(-1 * Math.PI * (f / B) * (f / B));

            return result;
        }

        private void gpibExample()
        {
            // Example use of GPIB code
            // Add AgVisa32.cs as an "existing item", add as a link by selecting the 
            // drop down menu on the "Add" button

            // Create session variable as ints
            int rm = 0;
            int psg = 0;
            int pm = 0;
            // String for responses from instruments
            string s;
            // doubles for parameters
            double freq = 3e9;
            double value = -200;

            // Do this once
            AgVisa32.viOpenDefaultRM(out rm);

            // Do this once for each SCPI instrument
            AgVisa32.viOpen(rm, "TCPIP0::169.254.28.87::5025::SOCKET", 0, 0, out psg);
            AgVisa32.viOpen(rm, "TCPIP0::169.254.28.88::INSTR", 0, 0, out pm);

            // Sending SCPI Commands...
            //Preset the Instruments
            AgVisa32.viPrintf(psg, ":SYSTem:PRESet\n");
            AgVisa32.viPrintf(pm, "*RST\n");
            AgVisa32.viPrintf(pm, ":SYSTem:PRESet\n");

            // Send commands with parameters
            AgVisa32.viPrintf(psg, ":SOURce:FREQuency:CW %f\n", freq);
            AgVisa32.viPrintf(pm, ":SENSe:FREQuency:CW %@3lf\n", freq);

            // Read back a string and convert to a double
            AgVisa32.viRead(pm, out s, 80);
            value = Math.Round(Convert.ToDouble(s), 2);

            // Close the sessions and the default RM
            AgVisa32.viClose(psg);
            AgVisa32.viClose(pm);
            AgVisa32.viClose(rm);
        }
    }
}